; Iconbar Addition 3.2 masterpatch
; x65 M65v50 (c) benj9


number_of_monitor_icon_engines	EQU	2

						AREA ARMex, CODE, READONLY  

						EXPORT	iconbaradd_start				
						IMPORT	mp_Bufferizer
						IMPORT	v01_RamLS
						IMPORT	v02_RamNetCH
						IMPORT	f064_GetVibraStatus
						IMPORT	f002_GetProfile
						IMPORT	f039_AddIconToIconbar
						IMPORT	f081_GetNetMode
						IMPORT	f035_DrawImg
						IMPORT	f037_DrawCanvas
						IMPORT	f022_sPrintf
						IMPORT	f017_OpenReadCloseFile
						IMPORT	f058_mfree_high

						
						CODE16
						
						DCB		"IconbrAdd3,benj9"
					
; ========================================================================================
	
						ENTRY
						
iconbaradd_start		PUSH	{R3, R4, R6, LR}
						LDR		R0,_id
						BL		mp_Bufferizer
						BEQ		iconbar_addition_x
						
						MOV		R4, #0
						
iconbaradd_std_loop		BL		std_icons
						ADD		R4, #1
						CMP		R4, #5 ; number of standard engines - 1
						BLE		iconbaradd_std_loop
					
					
iconbar_addition_x		LDR		R7, repatch_1 ; repatch
						BLX		R7
						LDR		R7, repatch_2 ; repatch
						BLX		R7
						POP		{R3, R4, R6, R7}
						ADD		R7, #4
						CMP		R0, #0 ; repatch
						BX		R7
						

		
; ========================================================================================	

std_icons				PUSH	{R4, LR} ; ; input: R4= module bit number {2.? cb engage}
						BL		_getpermit
						BEQ		std_icons_x_0
						
						LSL		R4, #1
						ADD		PC, R4
						
std_icons_x_0			POP		{R4, PC}

						B		std_icons_profiles
						B		std_icons_charging
						B		std_icons_vibra
						B		std_icons_netmode
						B		std_icons_animation
						B		std_icons_netpos
						
; -----------------------------------------------------------------------------------	

std_icons_charging		BL		v01_RamLS

						LDRB	R0, [R7] ; 0: no charging. 1+2: charging. 3: full
						CMP		R0 ,#0
						BEQ		std_icons_x_0
						
						SUB		R0, #1
						LSR		R0, #1
						LSL		R0, #2
						ADD		R0, #4 ; {4 i iconCharge}{8 i iconFull}
						
						B		std_icons_vibra_x

; -----------------------------------------------------------------------------------	
					
std_icons_vibra			BL		f064_GetVibraStatus
							
						LSL		R0, #2
						ADD		R0, #12 ; {12 i iconNoVibra } {16 i iconVibra}
						
std_icons_vibra_x		MOV		R7, #0 ; no xy position
						B		std_icons_geticon

; -----------------------------------------------------------------------------------	
					
std_icons_profiles		BL		f002_GetProfile
						MOV		R2, R0
						
						MOV		R0, #20 ; {20 i iconFirst}
						
						BL		_geticon 
						ADD		R1, R2
						
						B		std_icons_iconbar
						
; -----------------------------------------------------------------------------------
	
std_icons_netmode		BL		f081_GetNetMode
						MOV		R2, R0

						CMP		R2, #5 ; SearchLow
						BLE		std_icons_netmode_srch1
						
						CMP		R2, #6 ; Phone
						BEQ		std_icons_netmode_phone
						
						CMP		R2, #8 ; SearchHi
						BLE		std_icons_netmode_srch2
						
						CMP		R2, #9 ; SMS
						BEQ		std_icons_netmode_sms
						
						CMP		R2, #0xf ; SearchHi
						BLE		std_icons_netmode_srch2
						
						CMP		R2, #0x12 ; SemiIdle
						BLE		std_icons_netmode_semi
						
						CMP		R2, #0x13 ; Idle
						BLE		std_icons_netmode_idle
						
std_icons_netmode_srch2	MOV		R0, #32 ; icon srch2; {32 i iconSearchingHi v=335}
						B		std_icons_geticon
						
std_icons_netmode_srch1	MOV		R0, #24 ; icon srch1; {24 i iconSearchingLo v=333}
						B		std_icons_geticon
																	
std_icons_netmode_phone	MOV		R0, #28 ; icon phone ; {28 i iconPhoneTraffic v=326}
						B		std_icons_geticon	
						
std_icons_netmode_sms	MOV		R0, #36 ; icon sms ; {36 i iconSmsTraffic v=332}
						B		std_icons_geticon
						
std_icons_netmode_semi	MOV		R0, #40 ; icon semi idle ; {40 i iconSemiIdle v=331}
						B		std_icons_geticon
						
std_icons_netmode_idle	MOV		R0, #44 ; icon idle ; {44 i iconIdle v=334}
						B		std_icons_geticon

; -----------------------------------------------------------------------------------		

std_icons_animation		LDRB	R3, [R6, #1] ; hidden animation counter
						LDR		R0, [R6, #48] ; {48 i `first icon` v=31}
						LDR		R2, [R6, #52] ; {52 i `last icon` v=36}
						ADD		R1, R0, R3
						CMP		R1, R2
						BLE		std_icons_animation_le
						
						MOV		R1, R0
						MOV		R3, #0
						
std_icons_animation_le	ADD		R3, #1
										
std_icons_animation_sto	STRB	R3, [R6, #1] ; animation counter
						B		std_icons_iconbar	
									
; -----------------------------------------------------------------------------------
_std_icons_netpos_unl	MOV		R4, LR
						LDR		R0, [R6, #60] ; string buffer ptr
						BL		f058_mfree_high
						ADD		SP, #0x30
						BX		R4
						
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -
						
								
std_icons_netpos_2nd	LDRB	R3, [R6, #3] ; hidden temp netpos flag
						CMP		R3, #0xFF
						BEQ		std_icons_netpos_2nd_1
						
						BL		_std_icons_netpos_unl
						POP		{R4, PC}

std_icons_netpos_2nd_1	MOV		R3, #0
						STRB	R3, [R6, #3] ; hidden temp netpos flag
						BL		v02_RamNetCH
						B		std_icons_netpos_1

; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -

std_icons_netpos		SUB		SP, #0x30
						MOV		R2, #0xFF
						STRB	R2, [R6, #3] ; hidden temp netpos flag
						
						BL		v02_RamNetCH
						LDRH	R3, [R7, #2] ; CI
std_icons_netpos_1		LDRH	R2, [R7, #4] ; LAC
						
						STR		R2, [SP]
						ADD		R0, SP, #4
						MOV		R1, R6
						ADD		R1, #72 ; {72 s miniGPS maxlen=31 value=`0:\\Misc\\gps\\%i\\%i-%i.tmo`}
						BL		f022_sPrintf
						
						ADD		R0, SP, #4
						MOV		R1, R6
						ADD		R1, #60 ; string buffer ptr
						BL		f017_OpenReadCloseFile
						BMI		std_icons_netpos_2nd
						
						LDR		R0, [R6, #60] ; string buffer ptr
						
						LDRH	R1, [R0] ; string len
						CMP		R1, #0
						BEQ		std_icons_netpos_2nd
						
						ADD		R0, #4 ; string starts ptr +4
						SUB		R1, #2
						LSL		R1, #1 ; cause of unicode double byte format "bb 00"
						MOV		R2, #0
						
std_icons_netpos_lp1	CMP		R2, R1
						BGT		std_icons_netpos_2nd
						
						LDRB	R3, [R0, R2]
						ADD		R2, #2
						CMP		R3, #0xA ; line feed
						BNE		std_icons_netpos_lp1

						LDRB	R3, [R0, R2]
						CMP		R3, #0xA ; line feed
						BNE		std_icons_netpos_2nd
						
						MOV		R4, R6
						ADD		R4, #64 ; 4 bytes for icon number as chars
						MOV		R7, R4
						ADD		R2, #2	
						
						MOV		R3, R2 
						ADD		R3, #14 ; max 8 chars (8-1)*7
						CMP		R3, R1
						BGE		std_icons_netpos_lp2
						
						MOV		R1, R3 ; correct lenght

std_icons_netpos_lp2	LDRB	R3, [R0, R2] ; load the char numbers
						STRB	R3, [R7] ; store them in buffer
						ADD		R7, #1
						ADD		R2, #2
						CMP		R2, R1
						BLE		std_icons_netpos_lp2

						MOV		R0, #1 ; power
						MOV		R1, #0 ; sum = icon
						MOV		R2, #10 ; power factor
						
std_icons_netpos_ch2int	SUB		R7, #1
						LDRB	R3, [R7]
						SUB		R3, #0x30 ; ascii to machine
						MUL		R3, R0 ; power up
						ADD		R1, R3
						MUL		R0, R2
						CMP		R7, R4
						BGT		std_icons_netpos_ch2int
		
						MOV		R3, R1
						
						BL		_std_icons_netpos_unl
						
						MOV		R1, R3
						MOV		R7, #56 ; {56 xy `position (off=iconbar)`}
						
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -
					
std_icons_geticon		BL		_geticon 
						BEQ		std_icons_x				

std_icons_netpos_draw	; input: R7=icon/xy-midlet-position ; 
						CMP		R7, #0 ; no xy-pos choice
						BEQ		std_icons_iconbar
						
						LDRB	R0, [R6, R7]; {56 xy `position (off=iconbar)`}
						ADD		R7, #1
						LDRB	R3, [R6, R7]; {56+1 xy `position (off=iconbar)`}
						
						CMP		R0, #0xFF
						BNE		std_icons_fixed
						
						CMP		R3, #0xFF
						BEQ		std_icons_iconbar
						
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -
											
std_icons_fixed			SUB		SP, #8

















						MOV		R2, R1
						MOV		R1, R3
								
						BL		f035_DrawImg
						
						POP		{R4, PC}
						
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -

std_icons_iconbar		BL		_addicon2bar
							
std_icons_x				POP		{R4, PC}
						
; -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -  -
					
xxxxxx

Draw_canvas		

				MOV		R0, R4
				BL		f033_GetImgHeight
				LDRB	R1, [R6, #2] ; icon_start_y  
				ADD		R1, R0
				MOV		R0, #1
				STR		R0, [SP, #4]
				SUB		R1, R0
				STR     R1, [SP]
				
				MOV		R0, R4
				BL		f034_GetImgWidth
				LDRB	R1, [R6, #1] ; icon_start_x 
				
				ADD		R3, R0, R1
				SUB		R3, #1
				
				LDRB	R2, [R6, #2] ; icon_start_y  
				LDR     R0, [SP,#0x14 + 2*4 + 8*4 ] ; normally: 0x14. add 8 for 2 regs sp. add 8*4 for 8 pushed regs by this func
				BL		f037_DrawCanvas	
				ADD		SP,#8
		

; ---------===========-----------============------------=============-----------====		


						
			
; ========================================================================================	

_addicon2bar			PUSH	{LR}
						ADD		R2, SP, #0x18 + 7 * 4 ; MainscreenIcon context
						MOV		R0, R5 ; MainscreenIcon context
						BL		f039_AddIconToIconbar
						POP		{PC}

; ========================================================================================	

_getpermit				; input: R4= module bit number
						LDRB	R1, [R6,#2] ; {2.? cb engage}
						LSR		R1, R4
						MOV		R2, #1
						AND		R1, R2
						BX		LR
						
; ========================================================================================	

_geticon				; input: R0= position in masterpatch midlet config
						LDR		R1, [R6, R0]
						CMP		R1, #0
						BX		LR ; Output: R1=icon-number 
						
; ========================================================================================	

repatch_1				DCD 0xA164FDF8 
repatch_2				DCD 0xA165033C ; CheckHomezoneStatus1

						DCD	0xB1C2D3E4
_id						DCD	0x00001c00, 0, 0

       				
        END  
        


1c00.ptc:

#1] ; hidden temp animation counter
#3] ; hidden temp netpostion flag





; -----------------------------------------------------------------------------------	
					

; main

monitor_icons_init		MOV		R0, #number_of_monitor_icon_engines
						SUB		R0, #1
						
						MOV		R3, #0x30 ; record length
						MUL		R0, R3
						
						MOV		R3, #12 ; offset for start of first monitor icons engine ram			
						ADD		R3, R0
						
monitor_icons_init_loop	BL		monitor_icons
						SUB		R3, #0x30					
						CMP		R3, #12 ; offset for start of first monitor icons engine ram			
						BGE		monitor_icons_init_loop
						
; ----- end of main
						
monitor_icons			PUSH	{R3, LR}
						ADD		R3, R6
						MOV		R2, #45 ; {(R3 + 45).0 cb engage}, {(R3 + 45).1 cb `use as pointer`} 
						LDRB	R4, [R3, R2]
						MOV		R2, #1 ; test bit 0: {(R3 + 45).0 cb engage}
						AND		R2, R4
						BEQ		monitor_icons_exit

						LDR		R7, [R3] ; R3 + 0: a focus v=A8752560
						MOV		R2, #2 ; test bit 1: {(R3 + 45).1 cb `use as pointer`}
						AND		R2, R4
						BNE		monitor_icons_focus_ptr ; address is indirect, by pointer
						
						LDRB	R7, [R7] ; direct addressing
						B		monitor_icons_preloop		

monitor_icons_focus_ptr	LDR		R7, [R7]
						MOV		R2, #47 ; {(R3+47) b offset}
						LDRB	R4, [R3, R2]	
						LDRB	R7, [R7, R4]
						
monitor_icons_preloop	MOV		R2, #44 ; R3 + 44 : permits for values {R3+44.? cb v?}
						LDRB	R0, [R3, R2]
						MOV		R4, #0
		
monitor_icons_loop		CMP		R4, #7 
						BEQ		monitor_icons_else
						
						BL		monitor_value_permit
						BEQ		monitor_icons_loop_x
						
						MOV		R2, #46 ; condition direction. 0=eq, 1=le, 2=ge
						LDRB	R1, [R3, R2]
						BL		monitor_value
						BEQ		monitor_icons_snapped 

monitor_icons_loop_x	LSR		R0, #1
						ADD		R4, #1
						B		monitor_icons_loop
						
monitor_icons_else		BL		monitor_value_permit
						BEQ		monitor_icons_exit
						
						MOV		R1,#0 ; condition direction. 0=eq, 1=le, 2=ge
						BL		monitor_value
						BEQ		monitor_icons_exit ; NOT this value
						
monitor_icons_snapped	LSL		R4, #2 ; *4
						MOV		R2, #4 ; R3 + 4: first icon
						ADD		R2, R4
						LDR		R1, [R3, R2]
						BL		_addicon2bar

monitor_icons_exit		POP		{R3, PC}


; -----------------------------------------------------------------------------------	

monitor_value_permit	MOV		R1, #1
						AND		R1, R0
						BX		LR

; -----------------------------------------------------------------------------------	

monitor_value			PUSH	{LR} ; input R1:  condition direction. 0=eq, 1=le, 2=ge
						MOV		R2, #36 ; 36 first byte value
						ADD		R2, R4 
						LDRB	R2, [R3, R2] 
						CMP		R1, #1 ; input R1:  condition direction. 0=eq, 1=le, 2=ge
						BEQ		monitor_value_le
						BGT		monitor_value_ge

monitor_value_equal		CMP		R7, R2 ; focus byte snapped?
						POP		{PC} ; BX		LR

monitor_value_le		CMP		R7, R2 ; focus byte snapped?
						BLE		monitor_value_true
						B		monitor_value_false
						
monitor_value_ge		CMP		R7, R2 ; focus byte snapped?
						BGE		monitor_value_true

monitor_value_false		MOV		R2, #0
						B		monitor_value_test

monitor_value_true		MOV		R2, #1				

monitor_value_test		CMP		R2,#1
						POP		{PC} ; outputs condition bits
						
						
; ========================================================================================
